/* ***********************************************************************
   *                                                                     *
   * latrig.h                                                            *
   * Christian Zurhorst, BID R&D, 29 Jul. 1998                           *
   *                                                                     *
   * trace memory trigger functions                                      *
   *                                                                     *
   ***********************************************************************

*/

#ifndef __LATRIG_H
#define __LATRIG_H

#include <latrdefs.h>


#ifdef __cplusplus
extern "C" {
#endif

CLI b_errtype EXPORT BestTrigSeqGenPropSet(      /* @tsgenprpset */
    b_handletype handle,                         
    b_trigseqgenproptype trigseqgenprop,         /* @prop        */
    b_int32 value                                /* @val         */
    );

CLI b_errtype EXPORT BestTrigSeqGenPropGet(      /* @tsgenprpget */
    b_handletype handle,
    b_trigseqgenproptype trigseqgenprop,         /* @prop        */
    b_int32  *value                              /* #RETURN "property value =  %d\n" */
    );

CLI b_errtype EXPORT BestTrigSeqGenPropDefaultSet( /* @tsgenprpdefset */
    b_handletype handle
    );

CLI b_errtype EXPORT BestTrigSeqTranPropSet(     /* @tstranprpset    */
    b_handletype handle, 
    b_int32 transient,                           /* @tran        */
    b_trigseqtranproptype trigseqtranprop,       /* @prop        */
    b_int32 value                                /* @val         */
    );   

CLI b_errtype EXPORT BestTrigSeqTranPropGet(     /* @tstranprpget    */
    b_handletype handle,
    b_int32 transient,                           /* @tran        */
    b_trigseqtranproptype trigseqtranprop,       /* @prop        */
    b_int32 *value                               /*  #RETURN  "property value = %d\n"*/
    );

CLI b_errtype EXPORT BestTrigSeqTranPropDefaultSet( /* @tstranprpdefset */
    b_handletype handle,
    b_int32 transient                            /* @tran     */
    );

CLI b_errtype EXPORT BestTrigSeqTranCondPropGet(   /* @tstrancprpget   */
    b_handletype handle,
    b_int32 transient,                             /* @tran        */
    b_trigseqtrancondproptype trigseqtrancondprop, /* @prop        */
    b_int32 *value                                 /*  #RETURN  "property value (parsed) = %08lx\\h\n"*/
    );

CLI b_errtype EXPORT BestTrigSeqTranCondPropSet(   /* @tstrancprpset   */
    b_handletype handle,                       
    b_int32 transient,                             /* @tran        */
    b_trigseqtrancondproptype trigseqtrancondprop, /* @prop        */
    b_charptrtype condition                        /* @con         */
    );

CLI b_errtype EXPORT BestTrigSeqPropDefaultSet(  /* @tsprpdefset */
    b_handletype handle
    );

CLI b_errtype EXPORT BestTrigSeqProg(            /* @tsprog   */
    b_handletype handle    
    );


#ifdef __cplusplus
}
#endif


#endif



